
# SimSimMdr.exe.config keys

## Keys related to the connection to simTree

### SimTreeApiAddress

The addess to simTree. Should have the the value:
"https://api-dot-secure-ripple-312910.nw.r.appspot.com"

### customerSchema

Enter your schema for logging in to simTree

### userName

Enter your userName for logging in to simTree

### password

Enter the password for logging in to simTree.
Any XML reserved characters must be escaped:

*     >    &gt;
*     <    &lt;
*     &    &amp;
*     %    &#37;

### switchId

The ID in simTree in to import calls to (default 1)

## Keys related to the connection to your database

### dbConnectionKind

Set the type of connection to the SQL database. Possible values:

* "0" - SQL Server
* "1" - ODBC

### sourceConnectionString

The connection string to you SQL database.

### sqlCommandTimeout

Enter the timeout for queries to your SQL database

## Keys related to the queries to your database

### databaseSystem

Sets default SQL queries. Possible values:

* "-1" - Custom queries
* "0" - Infinity (Only default queries for calls)
* "1" - Genesis
* "2" - Avaya (Only default queries for calls)

#### Infinity callsQuery

    SELECT TOP 500 ID, 
      DATEADD(MINUTE,[Timestamp], '1899-12-31') AS timestamp,
      CAST(CASE WHEN CallKind in (0, 1, 3, 16) THEN [Wraptime] ELSE [Optime] END AS int) AS 'wrap',
      CAST([Talk] AS int) AS talk,
      CAST([Account] AS bigint) as tag1, 
      CAST([Billing] AS bigint) as tag2, 
      [CDTNum] as tag3,
      [Abandoned]+[SysAbandon]{vmcbAbandon}+[GreetHangup] as 'Abandons'
    FROM mCallEnd
    WHERE (CallKind in (0, 16, 2, 3, 4) or (CallKind = 1 and talk > 0)) 
    AND talk BETWEEN -2147483648 AND 2147483647 AND [Wraptime] BETWEEN -2147483648 AND 2147483647 AND [Optime] BETWEEN -2147483648 AND 2147483647
    AND [Account] NOT IN (0, 800) AND [Billing] NOT IN (0, 800) AND ID > @minId ORDER BY ID

#### Infinity callsMinIDQuery

    SELECT MIN(ID) FROM mCallEnd WHERE DATEADD(MINUTE,[Timestamp], '1899-12-31') > @dt

#### Genesis callsQuery

    SELECT TOP 500 CAST(CE.callId AS int) as CallID, 
      CS.Stamp as timestamp, 
      CAST(1000 * CE.selDisc AS int) AS 'wrap',
      CAST(1000 * CE.selTalk AS int) AS 'talk',
      TRY_CAST(C.ClientNumber AS bigint) AS tag1,
      TRY_CAST(C.BillingCode AS bigint) AS tag2,
      CAST(C.Skill AS int) AS tag3,
      case when ce . agtId Is Not NULL and ce . kind in ( 1 , 2 ) and ce . selTalk = 0 and ce . CompCode = 3 Then 1 --Abandon
      When ce . CompCode = 2 Then 1 --System Abandon
      --When ce.agtId Is Null and ce.kind in (1,2) and ce.CompCode=0 Then 1 --Greeting Hangup
      Else 0
      End as Abandons
    FROM dbo.statCallEnd CE
    JOIN dbo.statCallStart CS ON CS . callId = CE . callId
    JOIN dbo.cltClients C ON C . cltId = CE . cltId
    WHERE CE . Kind in ( 1 , 2 , 3 , 4 , 20 , 21 , 20 )
    AND CE.callId > @minId ORDER BY CE.callId

#### Genesis callsMinIDQuery

    SELECT CAST(MIN(callId) AS int) FROM dbo.statCallEnd WHERE Stamp > @dt

#### Genesis agentEventsQuery

    SELECT [Name] as employeeSwitchId
      , [stamp] as StartTime
      , CAST([type] - 1 AS int) AS kind
      , [value] as reasonCode
    FROM dbo.statAgentTracker
    WHERE [type] IN (1, 2, 3, 4) AND Stamp >= @minDt AND Stamp < @maxDt
    AND stationType in (0, 10, 29)

#### Avaya callsByDateQuery

    SELECT
      CAST(ROW_DATE AS DATETIME YEAR TO MINUTE) + (60 * FLOOR(STARTTIME/100) + MOD(STARTTIME, 100)) UNITS MINUTE AS timestamp,
      CAST(SPLIT AS INT8) AS tag1,
      CAST(ABNCALLS AS INTEGER) AS abandon
    FROM hsplit
    WHERE
      CAST(ROW_DATE AS DATETIME YEAR TO MINUTE) + (60 * FLOOR(STARTTIME/100) + MOD(STARTTIME, 100)) UNITS MINUTE >= ?
      AND
      CAST(ROW_DATE AS DATETIME YEAR TO MINUTE) + (60 * FLOOR(STARTTIME/100) + MOD(STARTTIME, 100)) UNITS MINUTE <= ?
    ORDER BY ROW_DATE, STARTTIME;

#### Avaya callsByDateAgenteQuery

    SELECT
      CAST(ROW_DATE AS DATETIME YEAR TO MINUTE) + (60 * FLOOR(STARTTIME/100) + MOD(STARTTIME, 100)) UNITS MINUTE AS timestamp,
      LOGID AS agent,
      CAST(SPLIT AS INT8) AS tag1,
      CAST(ACDCALLS AS INTEGER) AS noc,
      CAST(1000 * I_ACDTIME AS INTEGER) AS talk,
      CAST(1000 * TI_AUXTIME AS INTEGER) AS wrap
    FROM hagent
    WHERE
      CAST(ROW_DATE AS DATETIME YEAR TO MINUTE) + (60 * FLOOR(STARTTIME/100) + MOD(STARTTIME, 100)) UNITS MINUTE >= ?
      AND
      CAST(ROW_DATE AS DATETIME YEAR TO MINUTE) + (60 * FLOOR(STARTTIME/100) + MOD(STARTTIME, 100)) UNITS MINUTE <= ?
    ORDER BY ROW_DATE, STARTTIME;  

### hasVmcbAbandon

In case of Infinty database ("databaseSystem"=0), if you have the [VmcbAbandon] column in mCallEnd table. Othervise ignored

### callsQuery

Optional query for retreiving calls, overriding the default:

         * Parameter @minId (32 bit integer)

         * Returns columns (in this order) 
           callId (32 bit integer),
           timestamp (datetime),
           wrap (32 bit integer, in milliseconds),
           talk (32 bit integer, in milliseconds),
           tag1 (64 bit integer, can be null),
           tag2 (64 bit integer, can be null),
           tag3 (32 bit integer, can be null),
           abandon (32 bit integer, 1 if abandon else 0),
           time_to_answer (32 bit integer, can be null, in milliseconds, this column can be omitted)

         * Return the calls in ascending order
         * Limit the number returned rows to 500
         * Use positional parameter in query, ?, if named parameter @minId does not work

### callsMinIDQuery

Optional query for getting the MIN(callId) for calls later than a given timestamp, overriding the default:

         * Parameter @dt (datetime)
         
         * Returns columns (in this order) 
           callId (32 bit integer)

### agentEventsQuery

Optional query for retreiving agent events between the given interval, overriding the default:

         * Parameter @minDt (datetime)
         * Parameter @maxDt (datetime)

         * Returns columns (in this order) 
           employeeSwitchId (32 bit integer),
           timestamp (datetime),
           kind (32 bit integer),
           reasonCode (string, can be null)

         * Possible kind values:
         * 0 = log in
         * 1 = log out
         * 2 = in rotation
         * 3 = out of rotation

### callsByDateQuery

Optional query for retreiving calls, overriding the default:

         * Parameter @minDt (datetime)
         * Parameter @maxDt (datetime)

         * Returns columns with following names
           timestamp (datetime),
           wrap (32 bit integer, in milliseconds), optional column
           talk (32 bit integer, in milliseconds), optional column
           tag1 (64 bit integer, can be null), optional column
           tag2 (64 bit integer, can be null), optional column
           tag3 (32 bit integer, can be null), optional column
           abandon (32 bit integer), the number of abandon

         * Return all calls for the given after @minDt and before or equal to @maxDt
         * Use positional parameter in query, ?, if named parameter does not work

### callsByDateAgentQuery

Optional query for retreiving calls, overriding the default:

         * Parameter @minDt (datetime)
         * Parameter @maxDt (datetime)

         * Returns columns with following names
           agent (string column type),
           timestamp (datetime),
           noc (32 bit integer), the number of calls
           wrap (32 bit integer, in milliseconds), optional column
           talk (32 bit integer, in milliseconds), optional column
           tag1 (64 bit integer, can be null), optional column
           tag2 (64 bit integer, can be null), optional column
           tag3 (32 bit integer, can be null), optional column

         * Return all calls for the given after @minDt and before or equal to @maxDt
         * Use positional parameter in query, ?, if named parameter does not work

## Other configuration keys

### importCalls

* "false" - calls are not imported
* "true" - calls are imported

### importAgentEvents

* "false" - agent events are not imported
* "true" - agent events are imported

### initialImportDays

Enter the number of days to import, if no data currently exists and the start date not set in simTree.

### callsByDateInterval

In case of importing call by date, the duration of the interval to import in hours.

Default "24"
